;The GIMP setup script, for Inno Setup 4.0.11+ (http://www.jrsoftware.org/); ISPP required
;extract all gimp's files in a folder (keeping the directory structure), and run the script from that
;folder
;
;other required files:
; - faq.rtf - FAQ displayed by the installer
; - gpl.rtf - GNU General Public Licence
; - logo.bmp - the image displayed on the first and last wizard pages
; - wilber.bmp - image displayed in the upper-left corner of the wizard
;
;revision history:
;20030905 - adapted Gimp 1.2 install script for Gimp 1.3
;20040111 - moved some dependencies to GTK+ 2 setup
;
;Made by Jernej Simoncic, jernej@ena.si

#pragma singlequotes(1)

;if source was checked out from CVS, which date
;#define cvsdate='20031031'

;gimp version
#define version='2.0-pre2'

#ifdef cvsdate
 #define gimpver=version+'-CVS-'+cvsdate
#else
 #define gimpver=version
#endif

[Setup]
AppName=The GIMP
;don't change AppID, otherwise the LZW installer won't find The Gimp!
AppID=WinGimp-1.3
AppVerName=The GIMP {#= gimpver}
AppPublisher=Tor Lillqvist
AppPublisherURL=http://www.gimp.org/win32/
AppSupportURL=http://groups.yahoo.com/group/gimpwin-users/
AppUpdatesURL=http://www2.arnes.si/~sopjsimo/gimp/
DefaultDirName={pf}\GIMP-2.0
DefaultGroupName=GIMP
AllowNoIcons=true
FlatComponentsList=yes
LicenseFile=gpl.rtf
;InfoBeforeFile=faq.rtf
ChangesAssociations=true
WizardImageFile=pre-2.0.bmp
WizardImageBackColor=$f2f5f3
WizardSmallImageFile=wilber.bmp
UseSetupLdr=no
OutputDir=_Output\47z
Compression=none
InternalCompressLevel=0
;AdminPrivilegesRequired=true
MinVersion=4,4
;WizardDebug=yes

[Tasks]
Name: desktopicon; Description: "Create a &desktop icon"; GroupDescription: "Additional icons:"; MinVersion: 4,4
Name: quicklaunchicon; Description: "Create a &Quick Launch icon"; GroupDescription: "Additional icons:"; MinVersion: 4,4; Flags: unchecked
;Name: gtkrc; Description: "Make The Gimp appear in the current Windows color scheme"; GroupDescription: "Interface"

[Components]
Name: base; Description: "Base"; Types: full compact; Flags: fixed
;Name: help; Description: "Help files"; Types: full custom normal
Name: loc; Description: "Translations (some may be incomplete)"; Types: full
#if 0
;TODO
Name: loc\ca; Description: "Catalan"; Types: full custom
Name: loc\cs; Description: "Czech"; Types: full custom
Name: loc\da; Description: "Danish"; Types: full custom
Name: loc\de; Description: "German"; Types: full custom
Name: loc\el; Description: "Greek"; Types: full custom
Name: loc\en_GB; Description: "English (United Kingdom)"; Types: full custom
Name: loc\es; Description: "Spanish"; Types: full custom
Name: loc\fi; Description: "Finnish"; Types: full custom
Name: loc\fr; Description: "French"; Types: full custom
Name: loc\ga; Description: "Irish"; Types: full custom
Name: loc\gl; Description: "Gallegan"; Types: full custom
Name: loc\hr; Description: "Croatian"; Types: full custom
Name: loc\hu; Description: "Hungarian"; Types: full custom
Name: loc\it; Description: "Italian"; Types: full custom
Name: loc\ja; Description: "Japanese"; Types: full custom
Name: loc\ko; Description: "Korean"; Types: full custom
Name: loc\lt; Description: "Lithuanian"; Types: full custom
Name: loc\nl; Description: "Dutch"; Types: full custom
Name: loc\nn; Description: "Norwegian Nynorsk"; Types: full custom
Name: loc\no; Description: "Norwegian"; Types: full custom
Name: loc\pl; Description: "Polish"; Types: full custom
Name: loc\pt; Description: "Portuguese"; Types: full custom
Name: loc\pt_BR; Description: "Portuguese (Brazil)"; Types: full custom
Name: loc\ro; Description: "Romanian"; Types: full custom
Name: loc\ru; Description: "Russian"; Types: full custom
Name: loc\sk; Description: "Slovak"; Types: full custom
Name: loc\sl; Description: "Slovenian"; Types: full custom
Name: loc\sv; Description: "Swedish"; Types: full custom
Name: loc\ta; Description: "Tamil"; Types: full custom
Name: loc\tr; Description: "Turkish"; Types: full custom
Name: loc\uk; Description: "Ukrainian"; Types: full custom
Name: loc\zh_CN; Description: "Chinese (Simplified)"; Types: full custom
Name: loc\zh_TW; Description: "Chinese (Traditional)"; Types: full custom
#endif

[Types]
;Name: normal; Description: "Typical installation"
Name: full; Description: "Full installation"
Name: compact; Description: "Compact installation"; Flags: iscustom
;Name: custom; Description: "Custom installation"; Flags: iscustom

[Files]
;GIMP base
Source: "bin\*.exe"; DestDir: "{app}\bin"; Components: base; Flags: recursesubdirs
Source: "etc\*.*"; DestDir: "{app}\etc"; Components: base; Flags: recursesubdirs
;Source: "lib\*.*"; DestDir: "{code:GetGTkDir|none}\lib"
Source: "bin\*.dll"; DestDir: "{app}\bin"; Components: base; Flags: recursesubdirs

Source: "{code:GetGTkDir|none}\libpng.dll"; DestDir: "{code:GetGTkDir|none}"; DestName: "libpng12.dll"; Components: base; Flags: external onlyifdoesntexist
Source: "{code:GetGTkDir|none}\jpeg-62.dll"; DestDir: "{code:GetGTkDir|none}"; DestName: "jpeg62.dll"; Components: base; Flags: external onlyifdoesntexist
Source: "{code:GetGTkDir|none}\zlib-1.dll"; DestDir: "{code:GetGTkDir|none}"; DestName: "zlib1.dll"; Components: base; Flags: external onlyifdoesntexist
;Source: "bin\*.dll"; DestDir: "{code:GetGTkDir|none}"; Components: base; Flags: recursesubdirs
;Source: "fonts\*.*"; DestDir: "{code:GetGTkDir|none}\..\etc\fonts"; Components: base; Flags: recursesubdirs

Source: "share\gimp\*.*"; DestDir: "{app}\share\gimp"; Components: base; Flags: recursesubdirs

Source: "lib\gimp\*.env"; DestDir: "{app}\lib\gimp"; Components: base; Flags: recursesubdirs
Source: "lib\gimp\*.dll"; DestDir: "{app}\lib\gimp"; Components: base; Flags: recursesubdirs
Source: "lib\gimp\*.exe"; DestDir: "{app}\lib\gimp"; Components: base; Flags: recursesubdirs

;GIMP localization
Source: "lib\locale\*.*"; DestDir: "{app}\lib\locale"; Components: loc; Flags: recursesubdirs
#if 0
;TODO
Source: "lib\locale\ca\*.*"; DestDir: "{app}\lib\locale\ca"; Flags: ignoreversion recursesubdirs; Components: loc\ca
Source: "lib\locale\cs\*.*"; DestDir: "{app}\lib\locale\cs"; Flags: ignoreversion recursesubdirs; Components: loc\cs
Source: "lib\locale\da\*.*"; DestDir: "{app}\lib\locale\da"; Flags: ignoreversion recursesubdirs; Components: loc\da
Source: "lib\locale\de\*.*"; DestDir: "{app}\lib\locale\de"; Flags: ignoreversion recursesubdirs; Components: loc\de
Source: "lib\locale\el\*.*"; DestDir: "{app}\lib\locale\el"; Flags: ignoreversion recursesubdirs; Components: loc\el
Source: "lib\locale\en_GB\*.*"; DestDir: "{app}\lib\locale\en_GB"; Flags: ignoreversion recursesubdirs; Components: loc\en_GB
Source: "lib\locale\es\*.*"; DestDir: "{app}\lib\locale\es"; Flags: ignoreversion recursesubdirs; Components: loc\es
Source: "lib\locale\fi\*.*"; DestDir: "{app}\lib\locale\fi"; Flags: ignoreversion recursesubdirs; Components: loc\fi
Source: "lib\locale\fr\*.*"; DestDir: "{app}\lib\locale\fr"; Flags: ignoreversion recursesubdirs; Components: loc\fr
Source: "lib\locale\ga\*.*"; DestDir: "{app}\lib\locale\ga"; Flags: ignoreversion recursesubdirs; Components: loc\ga
Source: "lib\locale\gl\*.*"; DestDir: "{app}\lib\locale\gl"; Flags: ignoreversion recursesubdirs; Components: loc\gl
Source: "lib\locale\hr\*.*"; DestDir: "{app}\lib\locale\hr"; Flags: ignoreversion recursesubdirs; Components: loc\hr
Source: "lib\locale\hu\*.*"; DestDir: "{app}\lib\locale\hu"; Flags: ignoreversion recursesubdirs; Components: loc\hu
Source: "lib\locale\it\*.*"; DestDir: "{app}\lib\locale\it"; Flags: ignoreversion recursesubdirs; Components: loc\it
Source: "lib\locale\ja\*.*"; DestDir: "{app}\lib\locale\ja"; Flags: ignoreversion recursesubdirs; Components: loc\ja
Source: "lib\locale\ko\*.*"; DestDir: "{app}\lib\locale\ko"; Flags: ignoreversion recursesubdirs; Components: loc\ko
Source: "lib\locale\lt\*.*"; DestDir: "{app}\lib\locale\lt"; Flags: ignoreversion recursesubdirs; Components: loc\lt
Source: "lib\locale\nl\*.*"; DestDir: "{app}\lib\locale\nl"; Flags: ignoreversion recursesubdirs; Components: loc\nl
Source: "lib\locale\nn\*.*"; DestDir: "{app}\lib\locale\nn"; Flags: ignoreversion recursesubdirs; Components: loc\nn
Source: "lib\locale\no\*.*"; DestDir: "{app}\lib\locale\no"; Flags: ignoreversion recursesubdirs; Components: loc\no
Source: "lib\locale\pl\*.*"; DestDir: "{app}\lib\locale\pl"; Flags: ignoreversion recursesubdirs; Components: loc\pl
Source: "lib\locale\pt\*.*"; DestDir: "{app}\lib\locale\pt"; Flags: ignoreversion recursesubdirs; Components: loc\pt
Source: "lib\locale\pt_BR\*.*"; DestDir: "{app}\lib\locale\pt_BR"; Flags: ignoreversion recursesubdirs; Components: loc\pt_BR
Source: "lib\locale\ro\*.*"; DestDir: "{app}\lib\locale\ro"; Flags: ignoreversion recursesubdirs; Components: loc\ro
Source: "lib\locale\ru\*.*"; DestDir: "{app}\lib\locale\ru"; Flags: ignoreversion recursesubdirs; Components: loc\ru
Source: "lib\locale\sk\*.*"; DestDir: "{app}\lib\locale\sk"; Flags: ignoreversion recursesubdirs; Components: loc\sk
Source: "lib\locale\sl\*.*"; DestDir: "{app}\lib\locale\sl"; Flags: ignoreversion recursesubdirs; Components: loc\sl
Source: "lib\locale\sv\*.*"; DestDir: "{app}\lib\locale\sv"; Flags: ignoreversion recursesubdirs; Components: loc\sv
Source: "lib\locale\ta\*.*"; DestDir: "{app}\lib\locale\ta"; Flags: ignoreversion recursesubdirs; Components: loc\ta
Source: "lib\locale\tr\*.*"; DestDir: "{app}\lib\locale\tr"; Flags: ignoreversion recursesubdirs; Components: loc\tr
Source: "lib\locale\uk\*.*"; DestDir: "{app}\lib\locale\uk"; Flags: ignoreversion recursesubdirs; Components: loc\uk
Source: "lib\locale\zh_CN\*.*"; DestDir: "{app}\lib\locale\zh_CN"; Flags: ignoreversion recursesubdirs; Components: loc\zh_CN
Source: "lib\locale\zh_TW\*.*"; DestDir: "{app}\lib\locale\zh_TW"; Flags: ignoreversion recursesubdirs; Components: loc\zh_TW
#endif

[INI]
;URL to Gimp-Win homepage
Filename: "{app}\gimp.url"; Section: "InternetShortcut"; Key: "URL"; String: "http://www.gimp.org/win32/"
;Filename: "{app}\gimpwinfaq.url"; Section: "InternetShortcut"; Key: "URL"; String: "http://wingimpfaq.cjb.net/"

[Registry]
;file associations main key
Root: "HKCR"; Subkey: "TheGIMP13"; ValueType: string; ValueName: ; ValueData: "GIMP image"; Flags: uninsdeletekey; Check: AdminCheck(yes)
Root: "HKCR"; Subkey: "TheGIMP13\DefaultIcon"; ValueType: string; ValueName: ; ValueData: "{app}\bin\gimp-1.3.exe,0"; Check: AdminCheck(yes)
#ifexist 'bin\\gimp-win-remote.exe'
Root: "HKCR"; Subkey: "TheGIMP13\shell\open\command"; ValueType: string; ValueName: ""; ValueData: """{app}\bin\gimp-win-remote.exe"" ""%1"""; Check: AdminCheck(yes)
#else
Root: "HKCR"; Subkey: "TheGIMP13\shell\open\command"; ValueType: string; ValueName: ""; ValueData: """{app}\bin\gimp-1.3.exe"" ""%1"""; Check: AdminCheck(yes)
#endif
;file types
Root: "HKCR"; Subkey: ".XCF"; ValueType: string; ValueName: ""; ValueData: "TheGIMP13"; Flags: uninsdeletevalue; Check: AdminCheck(yes)
Root: "HKCR"; Subkey: ".PAT"; ValueType: string; ValueName: ""; ValueData: "TheGIMP13"; Flags: uninsdeletevalue; Check: AdminCheck(yes)
Root: "HKCR"; Subkey: ".GIH"; ValueType: string; ValueName: ""; ValueData: "TheGIMP13"; Flags: uninsdeletevalue; Check: AdminCheck(yes)
Root: "HKCR"; Subkey: ".GBR"; ValueType: string; ValueName: ""; ValueData: "TheGIMP13"; Flags: uninsdeletevalue; Check: AdminCheck(yes)
;check the [Code] section!!
Root: "HKCR"; Subkey: ".BMP"; ValueType: string; ValueName: ""; ValueData: "TheGIMP13"; Flags: uninsdeletevalue; Check: AssocCheck(BMP)
Root: "HKCR"; Subkey: ".CEL"; ValueType: string; ValueName: ""; ValueData: "TheGIMP13"; Flags: uninsdeletevalue; Check: AssocCheck(CEL)
Root: "HKCR"; Subkey: ".FITS"; ValueType: string; ValueName: ""; ValueData: "TheGIMP13"; Flags: uninsdeletevalue; Check: AssocCheck(FITS)
Root: "HKCR"; Subkey: ".FLI"; ValueType: string; ValueName: ""; ValueData: "TheGIMP13"; Flags: uninsdeletevalue; Check: AssocCheck(FLI)
Root: "HKCR"; Subkey: ".HRZ"; ValueType: string; ValueName: ""; ValueData: "TheGIMP13"; Flags: uninsdeletevalue; Check: AssocCheck(HRZ)
Root: "HKCR"; Subkey: ".JPEG"; ValueType: string; ValueName: ""; ValueData: "TheGIMP13"; Flags: uninsdeletevalue; Check: AssocCheck(JPEG)
Root: "HKCR"; Subkey: ".JPG"; ValueType: string; ValueName: ""; ValueData: "TheGIMP13"; Flags: uninsdeletevalue; Check: AssocCheck(JPEG)
Root: "HKCR"; Subkey: ".PCX"; ValueType: string; ValueName: ""; ValueData: "TheGIMP13"; Flags: uninsdeletevalue; Check: AssocCheck(PCX)
Root: "HKCR"; Subkey: ".PIX"; ValueType: string; ValueName: ""; ValueData: "TheGIMP13"; Flags: uninsdeletevalue; Check: AssocCheck(PIX)
Root: "HKCR"; Subkey: ".PNG"; ValueType: string; ValueName: ""; ValueData: "TheGIMP13"; Flags: uninsdeletevalue; Check: AssocCheck(PNG)
Root: "HKCR"; Subkey: ".PNM"; ValueType: string; ValueName: ""; ValueData: "TheGIMP13"; Flags: uninsdeletevalue; Check: AssocCheck(PNM)
Root: "HKCR"; Subkey: ".PSD"; ValueType: string; ValueName: ""; ValueData: "TheGIMP13"; Flags: uninsdeletevalue; Check: AssocCheck(PSD)
Root: "HKCR"; Subkey: ".PSP"; ValueType: string; ValueName: ""; ValueData: "TheGIMP13"; Flags: uninsdeletevalue; Check: AssocCheck(PSP)
Root: "HKCR"; Subkey: ".PS"; ValueType: string; ValueName: ""; ValueData: "TheGIMP13"; Flags: uninsdeletevalue; Check: AssocCheck(PS)
Root: "HKCR"; Subkey: ".SGI"; ValueType: string; ValueName: ""; ValueData: "TheGIMP13"; Flags: uninsdeletevalue; Check: AssocCheck(SGI)
Root: "HKCR"; Subkey: ".RAS"; ValueType: string; ValueName: ""; ValueData: "TheGIMP13"; Flags: uninsdeletevalue; Check: AssocCheck(RAS)
Root: "HKCR"; Subkey: ".TGA"; ValueType: string; ValueName: ""; ValueData: "TheGIMP13"; Flags: uninsdeletevalue; Check: AssocCheck(TGA)
Root: "HKCR"; Subkey: ".TIF"; ValueType: string; ValueName: ""; ValueData: "TheGIMP13"; Flags: uninsdeletevalue; Check: AssocCheck(TIFF)
Root: "HKCR"; Subkey: ".TIFF"; ValueType: string; ValueName: ""; ValueData: "TheGIMP13"; Flags: uninsdeletevalue; Check: AssocCheck(TIFF)
Root: "HKCR"; Subkey: ".WMF"; ValueType: string; ValueName: ""; ValueData: "TheGIMP13"; Flags: uninsdeletevalue; Check: AssocCheck(WMF)
Root: "HKCR"; Subkey: ".XBM"; ValueType: string; ValueName: ""; ValueData: "TheGIMP13"; Flags: uninsdeletevalue; Check: AssocCheck(XBM)
Root: "HKCR"; Subkey: ".XWD"; ValueType: string; ValueName: ""; ValueData: "TheGIMP13"; Flags: uninsdeletevalue; Check: AssocCheck(XWD)
Root: "HKCR"; Subkey: ".XPM"; ValueType: string; ValueName: ""; ValueData: "TheGIMP13"; Flags: uninsdeletevalue; Check: AssocCheck(XPM)

;path
Root: "HKLM"; SubKey: "Software\Microsoft\Windows\CurrentVersion\App Paths\gimp-1.3.exe"; ValueType: string; ValueName: ""; ValueData: "{app}\bin\gimp-1.3.exe"; Check: AdminCheck(yes)
Root: "HKLM"; SubKey: "Software\Microsoft\Windows\CurrentVersion\App Paths\gimp-1.3.exe"; ValueType: string; ValueName: "Path"; ValueData: "{app}\bin;{code:GetGTkDir|none}"; Check: AdminCheck(yes)

[Icons]
Name: "{group}\GIMP 2"; Filename: "{app}\bin\gimp-1.3.exe"; WorkingDir: "{code:GetGTkDir|none}"
Name: "{userdesktop}\GIMP 2"; Filename: "{app}\bin\gimp-1.3.exe"; WorkingDir: "{code:GetGTkDir|none}"; MinVersion: 4,4; Tasks: desktopicon
Name: "{userappdata}\Microsoft\Internet Explorer\Quick Launch\GIMP 2"; Filename: "{app}\bin\gimp-1.3.exe"; WorkingDir: "{code:GetGTkDir|none}"; MinVersion: 4,4; Tasks: quicklaunchicon

[Run]
;Filename: "{app}\bin\gimp.exe"; Description: "Launch The GIMP"; Flags: postinstall nowait skipifsilent
Filename: "{app}\bin\gimp-1.3.exe"; Description: "Launch The GIMP"; Flags: postinstall nowait skipifsilent shellexec

[UninstallDelete]
Type: "files"; Name: "{app}\gimp.url"
;Type: "files"; Name: "{app}\gimpwinfaq.url"
Type: "files"; Name: "{app}\lib\gimp\1.2\plug-ins\gif.exe"

[Messages]
WelcomeLabel1=Welcome to [name] Setup Wizard
AboutSetupNote=Setup built by Jernej Simoncic, jernej.simoncic@guest.arnes.si

[Code]
program Setup;

  type
  DWORD = Cardinal;
  TSystemInfo = record
    wProcessorArchitecture: Word;
    wReserved: Word;
    dwPageSize: DWORD;
    lpMinimumApplicationAddress: Integer;
    lpMaximumApplicationAddress: Integer;
    dwActiveProcessorMask: DWORD;
    dwNumberOfProcessors: DWORD;
    dwProcessorType: DWORD;
    dwAllocationGranularity: DWORD;
    wProcessorLevel: Word;
    wProcessorRevision: Word;
  end;

  //functions to get BPP & resolution
  function DeleteDC(hDC: Integer): Integer; external 'DeleteDC@GDI32 stdcall';
  function CreateDC(lpDriverName, lpDeviceName, lpOutput: String; lpInitData: Integer): Integer; external 'CreateDCA@GDI32 stdcall';
  function GetDeviceCaps(hDC, nIndex: Integer): Integer; external 'GetDeviceCaps@GDI32 stdcall';

  function GetSysColor(nIndex: Integer): Integer; external 'GetSysColor@user32 stdcall';

	procedure GetSystemInfo(var lpSystemInfo: TSystemInfo); external 'GetSystemInfo@kernel32.dll stdcall';

  Const 
    GTkRegPath = 'SOFTWARE\GTk\2.0';
    RegKey = 'Inno Setup: App Path';

    HORZRES = 8;
    BITSPIXEL = 12;
    PLANES = 14;
    
    NumAssoc = 21; // number of file associations

  var
    AssocPrompts, AssocValues: TArrayOfString;
    Key: String;
    DataDir: String;
    i: Integer;
    ext: String;
    Warnings: Integer;
    GTkDir, GTKVer: String;

  function GetCPU(): Word;
	var
  	SysInfo: TSystemInfo;
  	S: String;
  begin
	  GetSystemInfo(SysInfo);
  	{S := 'Arch:' + IntToStr(SysInfo.wProcessorArchitecture) + '// PageSize:' + IntToStr(SysInfo.dwPageSize)
  	     + '// actCPUmask:' + IntToStr(SysInfo.dwActiveProcessorMask) + '// num cpu:' +
  	     IntToStr(SysInfo.dwNumberOfProcessors) + '// CPU type:' + IntToStr(SysInfo.dwProcessorType) +
  	     '// Alloc.Gran:' + IntToStr(SysInfo.dwAllocationGranularity) + '// cpu level:' +
  	     IntToStr(SysInfo.wProcessorLevel) + '// cpu rev:' + intToStr(SysInfo.wProcessorRevision);
  	     
  	MsgBox(S,mbInformation,0);}
  	
		Result := SysInfo.wProcessorLevel;
	end;

  function InitializeSetup(): Boolean;
  var xres, bpp, pl, tmp, rescode: Integer;
      cpuID, cpuFam: String;
      hDC: Integer;
  begin
    Result := True;

    If not RegQueryStringValue(HKLM, GTkRegPath, 'Path', GTkDir) then //find GTK+
      RegQueryStringValue(HKCU, GTkRegPath, 'Path', GTkDir);          //install dir

    If not RegQueryStringValue(HKLM, GTkRegPath, 'Version', GTKVer) then //GTK+ version
      RegQueryStringValue(HKCU, GTkRegPath, 'Version', GTKVer);

    //File associations
    SetArrayLength(AssocPrompts, NumAssoc+1);
    SetArrayLength(AssocValues, NumAssoc+1);
    //to change number of file associations, set the NumAssoc constant.
    AssocPrompts[0] := 'BMP - Windows Bitmap';
    AssocPrompts[1] := 'CEL - KISS CEL';
    AssocPrompts[2] := 'FITS - Flexible Image Transport System';
    AssocPrompts[3] := 'FLI - AutoDesk Animator';
    AssocPrompts[4] := 'GIF - CompuServe Graphics Interchange Format';
    AssocPrompts[5] := 'HRZ';
    AssocPrompts[6] := 'JPEG/JPG - Joint Photographers Expert Group';
    AssocPrompts[7] := 'PCX - ZSoft PaintBrush';
    AssocPrompts[8] := 'PIX';
    AssocPrompts[9] := 'PNG - Portable Network Graphics';
    AssocPrompts[10] := 'PNM';
    AssocPrompts[11] := 'PSD - Adobe PhotoShop';
    AssocPrompts[12] := 'PSP - Jasc PaintShopPro';
    AssocPrompts[13] := 'PS - PostScript';
    AssocPrompts[14] := 'SGI';
    AssocPrompts[15] := 'RAS - Sun Raster';
    AssocPrompts[16] := 'TGA - Targa';
    AssocPrompts[17] := 'TIFF/TIF - Tagged Image File Format';
    AssocPrompts[18] := 'WMF - Windows MetaFile';
    AssocPrompts[19] := 'XBM - X10/X11 Bitmap';
    AssocPrompts[20] := 'XWD';
    AssocPrompts[21] := 'XPM';

    // Try to find the settings that were stored last time
    for i := 0 to NumAssoc do
    begin
      ext:='Ext' + IntToStr(i);
      AssocValues[i] := GetPreviousData(ext, AssocValues[i]);
    end;

    //get resolution & BPP
    hDC := CreateDC('DISPLAY', '', '', 0);
    pl := GetDeviceCaps(hDC, PLANES);
    bpp := GetDeviceCaps(hDC, BITSPIXEL);
    xres := GetDeviceCaps(hDC, HORZRES);
    tmp := DeleteDC(hDC);
    tmp := pl * bpp;

    //variable Warnings holds differens errors detected at beginning of installation; if bit 1 is set,
    //the installer won't start
    
    if tmp<16 then //color depth
      Warnings:=Warnings Or 2;

    if xres<1024 then //resolution
      Warnings:=Warnings Or 4;

    if IsAdminLoggedOn=False then //admin
      Warnings:=Warnings Or 8;

    If IsAdminLoggedOn=False then
      If RegValueExists(HKLM, GTkRegPath, RegKey) then //GTK+ was installed by admin but user isn't admin
      begin
        Warnings:=Warnings or 64;
        Warnings:=Warnings or 1;
      end;

    If (GTkDir='') then //GTK was not found
    begin

      Warnings:=Warnings Or 16;
      Warnings:=Warnings Or 1;

    end else
    begin //detect if the libraries are in bin (my installer) or lib (dropline) subdir
    
      if FileExists(GTKDir + '\bin\libgtk-win32-2.0-0.dll') then
        GTKDir := GTKDir + '\bin'
      else if FileExists(GTKDir + '\lib\libgtk-win32-2.0-0.dll') then
        GTKDir := GTKDir + '\lib'
      else
      begin
        Warnings:=Warnings Or 16; //neither, something is wrong
        Warnings:=Warnings Or 1;
      end;

      //detect if new enough GTK+ installer was used (some dependencies were moved to the GTK+ installer)
      if not FileExists(GTKDir + '\libfontconfig-1.dll') then
        Warnings := Warnings or 1025;
      if not FileExists(GTKDir + '\freetype-6.dll') then
        Warnings := Warnings or 1025;
      if not FileExists(GTKDir + '\libpangoft2-1.0-0.dll') then
        Warnings := Warnings or 1025;

    end;

    if (GTKDir <> '') and (GTKVer < '2.2.4-2') then //too old GTK+ version
    begin
      Warnings:=Warnings Or 128;
      Warnings:=Warnings Or 1;
    end;
    
    if not UsingWinNT() then
      Warnings := Warnings or 256;
      
    //detect CPU
    If (GetCPU < 6) then
      Warnings := Warnings or 513;
      
    for i := 1 to ParamCount do
      if Pos('/ignoreerrors',Lowercase(ParamStr(i))) > 0 then
        if (Warnings and 1) = 1 then
          Warnings := Warnings Xor 1;

    //Warnings := 513;

    #ifdef cvsdate
    MsgBox('Warning! This version of Gimp was built from the source code checked out from CVS on {#= cvsdate}. Keep this in mind when reporting bugs.',mbInformation,0);
    #endif

  end;


  procedure RegisterPreviousData(PreviousDataKey: Integer);
  var i: integer;
      CurSubPage: Integer;
      ext: string;
  begin
    //Save informations about selected associations
    for i := 0 to NumAssoc do
    begin
      ext:='Ext' + IntToStr(i);
      SetPreviousData(PreviousDataKey, ext, AssocValues[i]);
    end;
  end;
  
  
  (* convert RGB color to BGR HEX value 
  function RGBBGR(q: Integer): String;
  var a,b,c: String;
      d,e: Integer;
  begin
  
    while q>0 do
    begin
      e := (q and 15) + 1;
      a := copy('0123456789ABCDEF', e, 1);
      q := q / 16;
      c := a + b;
      b := c;
    end;
    
    d:=6-Length(b);
    if d>0 then
    begin
      c := StringOfChar('0',d) + b;
      b := c;
    end;

    a := copy(b,1,2);
    c := copy(b,5,2);
    b := copy(b,3,2);

    Result := c + b + a;
  end;*)


  function ScriptDlgPages(CurPage: Integer; BackClicked: Boolean): Boolean;
  var CurSubPage,i: Integer;
      Next: Boolean;
      Text, GTKRC: String;
      S: String;
      clBtnFace,clBtnShadow,clBtnLight,clText,clGrayText,clHilight,clHilightText,
      clTooltip,clTooltipText,clWindow,clWindowText: String;
      clHex: String;
  begin

    if (not BackClicked and (CurPage = wpSelectProgramGroup)) or (BackClicked and (CurPage = wpSelectTasks)) then
    begin
      ///////////////////////////
      // File Association page //
      ///////////////////////////
      ScriptDlgPageOpen();

      if not BackClicked then
        CurSubPage := 0
      else
        CurSubPage := 1;
        
      while (CurSubPage>=0) and (CurSubPage<=1) and not Terminated do
      begin
        case CurSubPage of
          0:
          begin

            if IsAdminLoggedOn=False then //no associations for non-admins :(
            begin
            
              ScriptDlgPageSetCaption('Select file associations');
              ScriptDlgPageSetSubCaption1('Which file types should be associated with the GIMP?');

              Text := 'You must run this setup as administrator to be able to select file associations.';

              Next := OutputMsg(Text,True);
              
            end else begin

              ScriptDlgPageSetCaption('Select file associations');
              ScriptDlgPageSetSubCaption1('Which file types should be associated with the GIMP?');
              ScriptDlgPageSetSubCaption2('Select file types to associate with the GIMP.'#13#13'Note: if file types are already registered with the GIMP, unselecting them will not de-associate them.');
              Next := InputOptionArray(AssocPrompts, AssocValues, False, True);

            end;

          end;
          1:
          begin

            ScriptDlgPageSetCaption('Notes on supported file formats');
            ScriptDlgPageSetSubCaption1('Please read the following important information before continuing.');
            
            //Text := 'GIF format uses LZW compression, which is covered with the Unisys patent, so The Gimp can only load GIF files.'#13#13;
            //Text := Text+'TIFF format may also use LZW compression. Such files can be loaded by The Gimp, but only uncompressed TIFF files can be saved.'#13#13;
            //Text := Text+'If you wish to be able to save GIF files, make sure that either you are in a country where Unisys doesn''t have a patent on the LZW algorithm, or that you have a license from Unisys, and download the LZW library.'#13#13;
            Text := '';
            Text := Text+'The Gimp requires GhostScript to be able to read PostScript files. You can download it from <http://ghostscript.sourceforge.net/>'#13#13;

            Next := OutputMsg(Text,True);

          end;
        end;

        if Next then
          CurSubPage := CurSubPage + 1
        else
          CurSubPage := CurSubPage - 1;
      end;

      if not BackClicked then
        Result := Next
      else
        Result := not Next;

      ScriptDlgPageClose(not Result);

    end else if (not BackClicked and (CurPage = {wpInfoBefore} wpLicense)) or (BackClicked and (CurPage = wpSelectDir)) then
    begin
      ////////////////////////////////////////
      // Warnings (color depth, resolution) //
      ////////////////////////////////////////
      If Warnings > 0 then begin //display the page only if necessary
        ScriptDlgPageOpen();
        ScriptDlgPageSetCaption('Warnings');
        ScriptDlgPageSetSubCaption1('There may be problems with your current configuration');

        Text := '';
        if (Warnings and 1024)=1024 then
          Text := Text+'-'#9'Incomplete install of GTK+ 2.0 runtimes was detected. Please install at GTK+ 2.2.4-1 or newer from <http://www2.arnes.si/~sopjsimo/gimp/devel.html>.'#13#13;
        if (Warnings and 512)=512 then
          Text := Text+'-'#9'This version of The Gimp was compiled for a Pentium II or better CPU and will not run on your current computer.'#13#13;
        if (Warnings and 256)=256 then
          Text := Text+'-'#9'Windows 9x/ME are not currently supported by The Gimp 1.3.'#13#13;
        if (Warnings and 128)=128 then
          Text := Text+'-'#9'GTK+ 2.0 older than GTK+ 2.2.4-2 was found on your computer. The Gimp 2.0-pre2 requires at least GTK+ 2 runtime enviroment version 2.2.4-2 to work.'#13#13;
        if (Warnings and 64)=64 then
          Text := Text+'-'#9'GTK+ 2.0 was installed by an user with administrative privileges. Because of that, only an user with administrative privileges can install The Gimp.'#13#13;
        if (Warnings and 16)=16 then
          Text := Text+'-'#9'GTK+ 2.0 was not found on your computer. Please install it before The Gimp.'#13#13;
        If (Warnings and 2)=2 then
          Text := Text+'-'#9'At least 16-bit color mode is recommended to run The Gimp.'#13#13;
        If (Warnings and 4)=4 then
          Text := Text+'-'#9'1024x768 or greater resolution is recommended to run The Gimp.'#13#13;
        if (Warnings and 8)=8 then
          Text := Text+'-'#9'You should run this installation with administrative privileges, otherwise the installer won''t be able to set the required registry entries for library paths and file associations. If The Gimp doesn''t work after the installation is complete, please uninstall it, and run the Setup again with administrative privileges.';

        if (Warnings and 1)=1 then
          Text := Text+'The Setup cannot continue.';

        if (Warnings and 1)<>1 then
          Next := OutputMsg(Text,True)
        else
        begin
          Next := OutputMsg(Text,False);
          exit;
        end;

        if not BackClicked then
          Result := Next
        else
          Result := not Next;

        ScriptDlgPageClose(not Result);
        
      end else begin
        Result := True;
      end;

    (*end else if CurPage = wpFinished then

    //GTK+ installer will take care of this in the future
    ////////////////////////////////
    // save color scheme to gtkrc //
    ////////////////////////////////
    begin

      GTKRC := ExpandConstant('{app}\etc\gimp\1.2\gtkrc_user');
      //GTKRC := GetGTkDir('')+'\etc\gimp\1.2\gtkrc_user';

      if (ShouldProcessEntry('base','gtkrc')=srYes) then
      begin
        if not FileExists(GTKRC) then
          MsgBox('Error: Windows color scheme could not be saved.',0,0)
        else
        begin
        
          //get the windows' colors
          clBtnFace := RGBBGR(GetSysColor(15));
          clBtnShadow := RGBBGR(GetSysColor(16));
          clBtnLight := RGBBGR(GetSysColor(20));
          clText := RGBBGR(GetSysColor(18));
          clWindow := RGBBGR(GetSysColor(5));
          clWindowText := RGBBGR(GetSysColor(8));
          clGrayText := RGBBGR(GetSysColor(17));
          clHilight := RGBBGR(GetSysColor(13));
          clHilightText := RGBBGR(GetSysColor(14));
          clTooltip := RGBBGR(GetSysColor(24));
          clTooltipText := RGBBGR(GetSysColor(23));
          
          
          //generate the gtkrc file
          S:='style "default"';
          S:=S+#13'{';
          S:=S+#13'  bg[NORMAL] = "#'+clBtnFace+'"';
          S:=S+#13'  bg[SELECTED] = "#'+clHilight+'"';
          S:=S+#13'  bg[INSENSITIVE] = "#'+clBtnFace+'"';
          S:=S+#13'  bg[ACTIVE] = "#'+clBtnFace+'"';
          S:=S+#13'  bg[PRELIGHT] = "#'+clHilight+'"';
          S:=S+#13'';
          S:=S+#13'  base[NORMAL] = "#'+clWindow+'"';
          S:=S+#13'  base[SELECTED] = "#'+clHilight+'"';
          S:=S+#13'  base[INSENSITIVE] = "#'+clBtnFace+'"';
          S:=S+#13'  base[ACTIVE] = "#'+clWindow+'"';
          S:=S+#13'  base[PRELIGHT] = "#'+clWindow+'"';
          S:=S+#13'';
          S:=S+#13'  text[NORMAL] = "#'+clHilightText+'"';
          S:=S+#13'  text[SELECTED] = "#'+clText+'"';
          S:=S+#13'  text[INSENSITIVE] = "#'+clBtnFace+'"';
          S:=S+#13'  text[ACTIVE] = "#'+clHilightText+'"';
          S:=S+#13'  text[PRELIGHT] = "#'+clHilightText+'"';
          S:=S+#13'';
          S:=S+#13'  fg[NORMAL] = "#'+clText+'"';
          S:=S+#13'  fg[SELECTED] = "#'+clText+'"';
          S:=S+#13'  fg[INSENSITIVE] = "#'+clGrayText+'"';
          S:=S+#13'  fg[ACTIVE] = "#'+clText+'"';
          S:=S+#13'  fg[PRELIGHT] = "#'+clText+'"';
          S:=S+#13'}';
          S:=S+#13'class "*" style "default"';
          S:=S+#13'';
          S:=S+#13'style "tooltip"';
          S:=S+#13'{';
          S:=S+#13'  bg[NORMAL] = "#'+clTooltip+'"';
          S:=S+#13'  fg[NORMAL] = "#'+clTooltipText+'"';
          S:=S+#13'}';
          S:=S+#13'widget "*gtk-tooltip*" style "tooltip"';
          S:=S+#13'';
          S:=S+#13'style "button" {';
          S:=S+#13'  bg[NORMAL]    = "#'+clBtnFace+'"';
          S:=S+#13'  bg[PRELIGHT]  = "#'+clBtnFace+'"';
          S:=S+#13'  bg[INSENSITIVE] = "#'+clBtnFace+'"';
          //S:=S+#13'  fg[PRELIGHT] = "#'+clHilight+'"';
          S:=S+#13'}';
          S:=S+#13'widget "*Gtk*Button*" style "button"';
          S:=S+#13'';
          S:=S+#13'style "text" {';
          S:=S+#13'  fg[NORMAL] = "#'+clWindowText+'"';
          S:=S+#13'}';
          S:=S+#13'widget_class "*Entry*" style "text"';
          S:=S+#13'widget_class "*Tree*" style "text"';
          S:=S+#13'widget_class "*Text*" style "text"';
          S:=S+#13'widget_class "*GtkSpinButton*" style "text"';
          S:=S+#13'widget_class "*Editable*" style "text"';
          S:=S+#13'widget_class "*Combo*" style "text"';
          S:=S+#13'';

          if not SaveStringToFile(GTKRC,S,False) then
            MsgBox('Error: could not update color scheme file.',0,0);

        end;
      end;
      
      Result := True;
    *)
    end {else if CurPage = wpSelectDir then
    begin
    

      if Pos(' ',WizardDirValue)>0 then
      begin
      
        S := 'Due to a problem with some versions of GLib, The Gimp 2.0 should not be installed to a path ';
        S := S + 'which contains spaces, as it may fail to load plugins.';
        S := S + #13#13'Do you wish to continue anyway?';
        
        if MsgBox(S,mbError,MB_YESNO) = IDYES then
          Result := True
        else
          Result := False;
          
      end else
        Result := True;


    end }else begin
      Result := True;
    end;
  end;


  function UpdateReadyMemo(Space, NewLine, MemoUserInfo, MemoDirInfo, MemoTypeInfo, MemoComponentsInfo, MemoGroupInfo, MemoTasksInfo: String): String;
  var S: String;
      ShowAssoc: Boolean;
  begin

    (* Fill the 'Ready Memo' with setup information *)

    S := MemoDirInfo + NewLine + NewLine;                //installation directory

    S := S + MemoTypeInfo + NewLine + NewLine;           //installation type (full/compact/custom)

    S := S + MemoComponentsInfo + NewLine + NewLine;     //selected components

    for i := 0 to NumAssoc do
      if AssocValues[i]='1' then
        ShowAssoc:=True;

    if ShowAssoc then
    begin
      S := S + 'File types to associate with The Gimp:'; //which file types to associate

      for i := 0 to NumAssoc do
        if AssocValues[i]='1' then
          S := S + NewLine + Space + AssocPrompts[i];

      S := S + NewLine + NewLine;
    end;

    S := S + MemoGroupInfo;                              //program group

    If MemoTasksInfo<>'' then
      S := S + NewLine + NewLine + MemoTasksInfo;        //additional icons

    Result := S;
  end;


  function NextButtonClick(CurPage: Integer): Boolean;
  var ResCode: Integer;
  begin
    Result := ScriptDlgPages(CurPage, False);
  end;


  function BackButtonClick(CurPage: Integer): Boolean;
  begin
    Result := ScriptDlgPages(CurPage, True);
  end;


  //GTK+ installation directory
  function GetGTkDir(S: String): String;
  begin
    Result := GTKdir;
  end;


  //Check, if file association should be registered.
  function AssocCheck(assoc: String): Boolean;
  var an: Integer;
  begin

    if IsAdminLoggedOn=false then //don't trigger warning dialogs if admin isn't logged on
      Result:=False
    else
    begin
    
      for i := 0 to NumAssoc do
      begin
        If Pos(assoc,AssocPrompts[i])>0 then
        begin
          If AssocValues[i]='1' then
            Result := True
          else
            Result := False;
        end;
      end;

    end;

  end;

  function AdminCheck(S: String): Boolean;
  begin
    if S='yes' then
    begin
      if IsAdminLoggedOn then
        Result:=True
      else
        Result:=False;
    end else
    begin
      if IsAdminLoggedOn then
        Result:=False
      else
        Result:=True;
    end;
  end;

begin
end.

